//+------------------------------------------------------------------+
//|                                         Heiken Ashi Smoothed.mq4 |
//|                        Copyright 2021, Juvenille Emperor Limited |
//|                                        www.juvenille-emperor.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2021, Juvenille Emperor Limited"
#property link      "www.juvenille-emperor.com"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 9
#property indicator_plots   9
//--- plot Label1
#property indicator_label1  "HA"
#property indicator_type1   DRAW_COLOR_CANDLES
#property indicator_color1  clrBlue,clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1



#include <MovingAverages.mqh>

input ENUM_MA_METHOD MaMetod =MODE_SMMA;
input int MaPeriod=6;
input ENUM_MA_METHOD MaMetod2 =MODE_LWMA;
input int MaPeriod2=2;

ENUM_MA_METHOD MaMethod,MaMethod2;

//--- indicator buffers
double         ColorCandlesBuffer1[];
double         ColorCandlesBuffer2[];
double         ColorCandlesBuffer3[];
double         ColorCandlesBuffer4[];
double         ExtMapBuffer5[];
double         ExtMapBuffer6[];
double         ExtMapBuffer7[];
double         ExtMapBuffer8[];
double         ColorCandlesColors[];

int ma_handle_open;
int ma_handle_close;
int ma_handle_high;
int ma_handle_low;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   if(MaMetod==0)
      MaMethod=MODE_SMA;
   if(MaMetod==1)
      MaMethod=MODE_EMA;
   if(MaMetod==2)
      MaMethod=MODE_SMMA;
   if(MaMetod==3)
      MaMethod=MODE_LWMA;

   if(MaMetod2==0)
      MaMethod2=MODE_SMA;
   if(MaMetod2==1)
      MaMethod2=MODE_EMA;
   if(MaMetod2==2)
      MaMethod2=MODE_SMMA;
   if(MaMetod2==3)
      MaMethod2=MODE_LWMA;

   ma_handle_close=iMA(_Symbol,0,MaPeriod,0,MaMethod,PRICE_CLOSE);
   ma_handle_open=iMA(_Symbol,0,MaPeriod,0,MaMethod,PRICE_OPEN);
   ma_handle_low=iMA(_Symbol,0,MaPeriod,0,MaMethod,PRICE_LOW);
   ma_handle_high=iMA(_Symbol,0,MaPeriod,0,MaMethod,PRICE_HIGH);
   SetIndexBuffer(0,ColorCandlesBuffer1,  INDICATOR_DATA);
   SetIndexBuffer(1,ColorCandlesBuffer2,INDICATOR_DATA);
   SetIndexBuffer(2,ColorCandlesBuffer3,INDICATOR_DATA);
   SetIndexBuffer(3,ColorCandlesBuffer4,INDICATOR_DATA);
   SetIndexBuffer(4,ColorCandlesColors,INDICATOR_COLOR_INDEX);
   SetIndexBuffer(5,ExtMapBuffer5,INDICATOR_DATA);
   SetIndexBuffer(6,ExtMapBuffer6,INDICATOR_DATA);
   SetIndexBuffer(7,ExtMapBuffer7,INDICATOR_DATA);
   SetIndexBuffer(8,ExtMapBuffer8,INDICATOR_DATA);
//for(int z=0;z<8;z++)
// PlotIndexSetInteger(z,PLOT_DRAW_TYPE,DRAW_LINE);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {

   ArraySetAsSeries(ColorCandlesBuffer1,true);
   ArraySetAsSeries(ColorCandlesBuffer2,true);
   ArraySetAsSeries(ColorCandlesBuffer3,true);
   ArraySetAsSeries(ColorCandlesBuffer4,true);
   ArraySetAsSeries(ColorCandlesColors,true);
   ArraySetAsSeries(ExtMapBuffer5,true);
   ArraySetAsSeries(ExtMapBuffer6,true);
   ArraySetAsSeries(ExtMapBuffer7,true);
   ArraySetAsSeries(ExtMapBuffer8,true);

   double maOpen,maClose,maLow,maHigh;
   double haOpen,haHigh,haLow,haClose;


   if(BarsCalculated(ma_handle_close)!=Bars(_Symbol,0))
      return(0);
   if(BarsCalculated(ma_handle_open)!=Bars(_Symbol,0))
      return(0);
   if(BarsCalculated(ma_handle_high)!=Bars(_Symbol,0))
      return(0);
   if(BarsCalculated(ma_handle_low)!=Bars(_Symbol,0))
      return(0);
   int limit=rates_total-prev_calculated-1;

   if(prev_calculated==0)
     {
      limit=rates_total-1-MathMax(MaPeriod,MaPeriod2);



      ArrayInitialize(ColorCandlesBuffer1,0);
      ArrayInitialize(ColorCandlesBuffer2,0);
      ArrayInitialize(ColorCandlesBuffer3,0);
      ArrayInitialize(ColorCandlesBuffer4,0);
      ArrayInitialize(ColorCandlesColors,0);
      ArrayInitialize(ExtMapBuffer5,0);
      ArrayInitialize(ExtMapBuffer6,0);
      ArrayInitialize(ExtMapBuffer7,0);
      ArrayInitialize(ExtMapBuffer8,0);
     }
   limit=MathMax(1,limit);  
   for(int pos=limit; pos>=0; pos--)
     {
      maOpen=GetVal(ma_handle_close,0,pos);
      maClose=GetVal(ma_handle_low,0,pos);
      maLow=GetVal(ma_handle_open,0,pos);
      maHigh=GetVal(ma_handle_high,0,pos);
      //----
      haOpen=(ExtMapBuffer5[pos+1]+ExtMapBuffer6[pos+1])/2;
      haClose=(maOpen+maHigh+maLow+maClose)/4;
      haHigh=MathMax(maHigh,MathMax(haOpen,haClose));
      haLow=MathMin(maLow,MathMin(haOpen,haClose));

      //if(haOpen<haClose)
        {
         ExtMapBuffer7[pos]=haLow;
         ExtMapBuffer8[pos]=haHigh;
        }
      // else
      //  {
      //ExtMapBuffer7[pos]=haHigh;
      //   ExtMapBuffer8[pos]=haLow;
      // }
      
      ExtMapBuffer5[pos]=haOpen;
      ExtMapBuffer6[pos]=haClose;

     }


   MAOnBuffer(MaMetod2,rates_total,prev_calculated,0,MaPeriod2,ExtMapBuffer5,ColorCandlesBuffer1);
   MAOnBuffer(MaMetod2,rates_total,prev_calculated,0,MaPeriod2,ExtMapBuffer8,ColorCandlesBuffer2);
   MAOnBuffer(MaMetod2,rates_total,prev_calculated,0,MaPeriod2,ExtMapBuffer7,ColorCandlesBuffer3);
   MAOnBuffer(MaMetod2,rates_total,prev_calculated,0,MaPeriod2,ExtMapBuffer6,ColorCandlesBuffer4);
   int i;
   for(i=0; i<limit; i++)
     {


      if(ColorCandlesBuffer4[i]>ColorCandlesBuffer1[i])
         ColorCandlesColors[i]=0;
      else
         ColorCandlesColors[i]=1;
     }
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void  MAOnBuffer(ENUM_MA_METHOD method,const int rates_total,const int prev_calculated,
                 const int begin,const int period,const double& price[],double& buffer[])
  {
   if(MaMethod2==MODE_SMA)
      SimpleMAOnBuffer(rates_total,prev_calculated,0,period,price,buffer);
   if(MaMethod2==MODE_EMA)
      ExponentialMAOnBuffer(rates_total,prev_calculated,0,period,price,buffer);
   if(MaMethod2==MODE_SMMA)
      SmoothedMAOnBuffer(rates_total,prev_calculated,0,period,price,buffer);
   if(MaMethod2==MODE_LWMA)
      LinearWeightedMAOnBuffer(rates_total,prev_calculated,0,period,price,buffer);

  }
//+------------------------------------------------------------------+
double GetVal(int handle,int buf,int shift)
  {
   if(handle==INVALID_HANDLE)
     {
      return 0;
     }
   double ar[];
   if(CopyBuffer(handle,buf,shift,1,ar)==-1)
      return 0;

   return ar[0];
  }
//+------------------------------------------------------------------+
double iMAOnArrayMQL4(double &array[],
                      int total,
                      int period,
                      int ma_shift,
                      int ma_method,
                      int shift)
  {
   double buf[],arr[];
   if(total==0)
      total=ArraySize(array);
   if(total>0 && total<=period)
      return(0);
   if(shift>total-period-ma_shift)
      return(0);
   switch(ma_method)
     {
      case MODE_SMA :
        {
         total=ArrayCopy(arr,array,0,shift+ma_shift,period);
         if(ArrayResize(buf,total)<0)
            return(0);
         double sum=0;
         int    i,pos=total-1;
         for(i=1; i<period; i++,pos--)
            sum+=arr[pos];
         while(pos>=0)
           {
            sum+=arr[pos];
            buf[pos]=sum/period;
            sum-=arr[pos+period-1];
            pos--;
           }
         return(buf[0]);
        }
      case MODE_EMA :
        {
         if(ArrayResize(buf,total)<0)
            return(0);
         double pr=2.0/(period+1);
         int    pos=total-2;
         while(pos>=0)
           {
            if(pos==total-2)
               buf[pos+1]=array[pos+1];
            buf[pos]=array[pos]*pr+buf[pos+1]*(1-pr);
            pos--;
           }
         return(buf[shift+ma_shift]);
        }
      case MODE_SMMA :
        {
         if(ArrayResize(buf,total)<0)
            return(0);
         double sum=0;
         int    i,k,pos;
         pos=total-period;
         while(pos>=0)
           {
            if(pos==total-period)
              {
               for(i=0,k=pos; i<period; i++,k++)
                 {
                  sum+=array[k];
                  buf[k]=0;
                 }
              }
            else
               sum=buf[pos+1]*(period-1)+array[pos];
            buf[pos]=sum/period;
            pos--;
           }
         return(buf[shift+ma_shift]);
        }
      case MODE_LWMA :
        {
         if(ArrayResize(buf,total)<0)
            return(0);
         double sum=0.0,lsum=0.0;
         double price;
         int    i,weight=0,pos=total-1;
         for(i=1; i<=period; i++,pos--)
           {
            price=array[pos];
            sum+=price*i;
            lsum+=price;
            weight+=i;
           }
         pos++;
         i=pos+period;
         while(pos>=0)
           {
            buf[pos]=sum/weight;
            if(pos==0)
               break;
            pos--;
            i--;
            price=array[pos];
            sum=sum-lsum+price*period;
            lsum-=array[i];
            lsum+=price;
           }
         return(buf[shift+ma_shift]);
        }
      default:
         return(0);
     }
   return(0);
  }
//+------------------------------------------------------------------+
